/* Copyright (c) 1986  P. A. Buhr */

/*
  Play a game of cards. The game consists of each player taking a
  number of cards from a deck and passing the deck to the player on
  the left. A player must take at least one card and no more then
  a certain maximum. The player that takes the last cards is the
  winner.
  
  */

#include <uSystem.h>

long random();

#define RandBetween( low, high ) ( random( ) % ( high - low + 1 ) + low );

#define MinCardsTaken 1
#define MaxCardsTaken 3

int MakePlay( int RemainingCards ) {
    int passing, took;
    
    if ( RemainingCards <= MaxCardsTaken ) {
	took = RemainingCards;
	passing = 0;
    } else {
	took = RandBetween( MinCardsTaken, MaxCardsTaken ); /* random no. between MinCardsTaken & MaxCardsTaken */
	passing = RemainingCards - took;
    } /* if */
    uPrintf( "pid:%xd took %d cards from %2d passing %2d to the left\n", uThisTask(  ), took, RemainingCards, passing );
    return( passing );
} /* MakePlay */

void player( ) {
    uTask dealer, left, right;
    int RemainingCards;
    
    dealer = uReceive( &left, sizeof( uTask ) );		/* get uTask of player on the left */
    uReply( dealer, NULL, 0 );
    
    for ( ;; ) {
	right = uReceive( &RemainingCards, sizeof( RemainingCards ) ); /* get cards from player on the right */
	uReply( right, NULL, 0 );
    if ( RemainingCards == 0 ) {			/* end of game ? */
	    uSend( left, NULL, 0, &RemainingCards, sizeof( RemainingCards ) ); /* tell player on left about the end of the game */
	    break;
	} /* exit */
	RemainingCards = MakePlay( RemainingCards );	/* make a play */
    if ( RemainingCards == 0 ) {			/* did I win ? */
	    uPrintf( "pid:%x WON\n", uThisTask(  ) );
	    uSend( left, NULL, 0, &RemainingCards, sizeof( RemainingCards ) ); /* tell player on left about the end of the game */
	    right = uReceive( &RemainingCards, sizeof( RemainingCards ) ); /* make sure all players heard */
	    uReply( right, NULL, 0 );
	    uPrintf( "all players ended\n" );
	    break;
	} /* exit */
	uSend( left, NULL, 0, &RemainingCards, sizeof( RemainingCards ) ); /* pass remaining cards to player on the left */
    } /* for */
    uDie( NULL, 0 );
} /* player */

#define MaxNoPlayers 8
#define MaxNoGames 5
#define MinNoCards 20
#define MaxNoCards 40

void uMain(  ) {
    uTask players[MaxNoPlayers];
    int NoOfGames, NoOfPlayers, NoOfCards;
    int i;
    
    for ( NoOfGames = 1; NoOfGames <= MaxNoGames; NoOfGames += 1 ) {
	NoOfPlayers = RandBetween( 2, MaxNoPlayers );	/* random no. between 2 & MaxNoPlayers */
	uPrintf( "The number of players is:%d\n", NoOfPlayers );
	
	NoOfCards = RandBetween( MinNoCards, MaxNoCards ); /* random no. between MinNoCards & MaxNoCards */
	uPrintf( "The number of cards is:%d\n", NoOfCards );
	
	for ( i = 0; i < NoOfPlayers; i += 1 ) {
	    players[i] = uEmit( player );		/* start player */
	} /* for */

	for ( i = 0; i < NoOfPlayers - 1; i += 1 ) {	/* send each player the pid of the player on the left */
	    uSend( players[i], NULL, 0, &players[i + 1], sizeof( uTask ) );
	} /* for */
	uSend( players[i], NULL, 0, &players[0], sizeof( uTask ) );

	uSend( players[0], NULL, 0, &NoOfCards, sizeof( NoOfCards ) ); /* the dealer starts the game */

	for ( i = 0; i < NoOfPlayers; i += 1 ) {
	    uAbsorb( players[i], NULL, 0 );		/* wait for completion of process */
	} /* for */
	uPrintf( "\n\n" );				/* whitespace between games */
    } /* for */
    uPrintf( "successful completion\n" );
} /* uMain */
