/* Bounded Buffer using Conditional Wait Monitor */
/* Copyright (c) 1986  P. A. Buhr */

/*
  Bounded Buffer
  
  This particular implementation of a bounded buffer uses a queue
  implemented by an array. One entry in the queue is wasted (hence
  the need for the "+ 1" for this extra element), so that it is not
  necessary to count the number of items in the queue for use in
  determining if the queue is full.
  */

#include <uMonitor.h>

uMonitor( PriorityAutomaticSignal ) {
#   define QueueSize 10
    
    struct queue {
	int front;					/* position of front of queue */
	int back;					/* position of back of queue */
	BufferElemType queue[QueueSize + 1];		/* queue of integers */
    }; /* queue */
    
    struct queue buffer = { 0, 1 };			/* bounded buffer, initialize front & back */
    
    uEntry qinsert( BufferElemType elem ) {
	uWaitUntil buffer.front != buffer.back;
	buffer.queue[buffer.back] = elem;		/* insert element in queue */
	buffer.back = ( buffer.back + 1 ) % ( QueueSize + 1 );
    } /* qinsert */
    
    uEntry BufferElemType qremove( ) {
	BufferElemType elem;
	
	uWaitUntil ( buffer.front + 1 ) % ( QueueSize + 1 ) != buffer.back;
	buffer.front = ( buffer.front + 1 ) % ( QueueSize + 1 );
	elem = buffer.queue[buffer.front];		/* remove element from queue */
	return( elem );
    } /* qremove */
}
