#include <uMonitor.h>

#define Girl 0
#define Boy 1
#define other(t) (1 - t)
    
uTask GirlBoycheck[2];					/* to check critial section */

uMonitor Dating (PriorityNonBlocking) {
    int InUse = 0;
    uCondition GirlBoy[2] = {U_CONDITION, U_CONDITION}, StartOfDate = U_CONDITION, EndOfDate = U_CONDITION;
    
    uEntry void StartDating(int t) {
	if (InUse || uCondLength(&GirlBoy[other(t)]) == 0) uWait GirlBoy[t];
	if (InUse == 0) uSignal GirlBoy[other(t)];	/* signal partner */
	InUse += 1;
	if (InUse == 1) {
	    GirlBoycheck[t] = uThisTask();
	    uWait StartOfDate;				/* wait for partner to start */
	} else {
	    GirlBoycheck[t] = uThisTask();
	    uSignal StartOfDate;			/* signal waiting partner */
	} /* if */
    } /* StartDating */

    uEntry void EndDating(void) {
	InUse -= 1;
	if (InUse == 1) {
	    uWait EndOfDate;				/* wait for partner to finish */
	} else {
	    uSignal EndOfDate;				/* signal waiting partner */
	    if (uCondLength(&GirlBoy[Girl]) != 0 && uCondLength(&GirlBoy[Boy]) != 0) /* if there is a pair  */
		uSignal GirlBoy[Girl];			/* signal one of the pair */
	} /* if */
    } /* EndDating */
}

void Person(int gender) {
    int i;
    uTask partner;
    char *names[2] = { "Girl", "Boy " };
    
    StartDating(gender);
    partner = GirlBoycheck[other(gender)];
    if (GirlBoycheck[gender] != uThisTask() || GirlBoycheck[other(gender)] != partner) {
	uError("interference\n");
    } /* if */
    uPrintf("%s:%x is dating %s:%x\n", names[gender], uThisTask(), names[other(gender)], partner);
    uDelay(3);
    if (GirlBoycheck[gender] != uThisTask() || GirlBoycheck[other(gender)] != partner) {
	uError("interference\n");
    } /* if */
    EndDating();
    uDie(NULL, 0);
} /* Person */

#define NoOfGirls 30
#define NoOfBoys 30

void uMain() {
    int i;
    uTask PidGirls[NoOfGirls], PidBoys[NoOfBoys];
    
    for (i = 0; i < NoOfGirls; i += 1) {
	PidGirls[i] = uEmit(Person, Girl);
	PidBoys[i] = uEmit(Person, Boy);
	uDelay(2);
    } /* for */
    
    for (i = 0; i < NoOfGirls; i += 1) {
	uAbsorb(PidGirls[i], NULL, 0);
    } /* for */
    
    for (i = 0; i < NoOfBoys; i += 1) {
	uAbsorb(PidBoys[i], NULL, 0);
    } /* for */
} /* uMain */
