/* Copyright (c) 1989  P. A. Buhr */

/*
  Method: Signal intent to enter the critical section, but do not
    do so until the other process is not interested in the
    critical section.
  Work?: NO
  Problem: Simultaneous declaration of intent results in an indefinite
    postponement of both processes waiting for each other.
*/

#include <uSystem.h>

#define WantIn 1
#define DontWantIn 0

void DeclareIntent(int *me, int *other) {
    int i;						/* loop counter */

    for (i = 1; i <= 1000; i += 1) {			/* exercise critical section */

        /* entry protocol */

        *me = WantIn;					/* declare intent */
        while (*other == WantIn) {}			/* busy wait */
    
        /* critical section */
    
        CriticalSection();

        /* exit protocol */

        *me = DontWantIn;				/* declare not interested */
    } /* for */

    uDie(NULL, 0);
} /* DeclareIntent */

void uMain() {
    uTask t0, t1;
    int me, other;					/* shared between processes */

    uSetTimeSlice(10);

    me = other = DontWantIn;
    t0 = uEmit(DeclareIntent, &me, &other);		/* start process */
    t1 = uEmit(DeclareIntent, &other, &me);		/* start process */
 
    uAbsorb(t0, NULL, 0);				/* wait for completion of process */
    uAbsorb(t1, NULL, 0);				/* wait for completion of process */
    uPrintf("successful execution\n");
} /* uMain */
