/* Copyright (c) 1989  P. A. Buhr */
/*
  Method: Prevent indefinite postponement by giving one process priority
    over the other when they both simultaneously declare intent.
  Work?: NO
  Problems: It is possible for one process to always obtain control of the
    critical section, hence violating the bounded waiting criterion.
  */

#include <uSystem.h>

#define WantIn 1
#define DontWantIn 0
#define HIGH 1
#define low 0

void PrioritizeEntry(int priority, int *me, int *other) {
    int i;						/* loop counter */

    for (i = 1; i <= 1000; i += 1) {			/* exercise critical section */

        /* entry protocol */

        if (priority == HIGH) {
            *me = WantIn;				/* declare intent */
            while (*other == WantIn);			/* busy wait */
        } else {
            *me = WantIn;				/* declare intent */
            while (*other == WantIn) {			/* back down & busy wait */
                *me = DontWantIn;			/* retract intent */
                while (*other == WantIn);		/* busy wait */
                *me = WantIn;				/* declare intent, again */
            } /* while */
        } /* if */
    
        /* critical section */
	
        CriticalSection();

        /* exit protocol */
	
        *me = DontWantIn;				/* declare not interested */
    } /* for */

    uDie(NULL, 0);
} /* PrioritizeEntry */

void uMain() {
    uTask t0, t1;
    int me, other;					/* shared between processes */

    uSetTimeSlice(10);
    
    me = other = DontWantIn;
    t0 = uEmit(PrioritizeEntry, HIGH, &me, &other);	/* start process */
    t1 = uEmit(PrioritizeEntry, low, &other, &me);	/* start process */
 
    uAbsorb(t0, NULL, 0);				/* wait for completion of process */
    uAbsorb(t1, NULL, 0);				/* wait for completion of process */
    uPrintf("successful execution\n");
} /* uMain */
