/* Copyright (c) 1989  P. A. Buhr */

/*
  Method: Modification of declaration of intent to prevent postponement.
    Retract intent if other process wants into critical section.
  Work?: NO
  Problem: Same as declaration of intent. Simultaneous declaration of
    intent and retraction results in indefinite postponement of both
    processes. However, because this now involves a large number of
    lines of code, there is little chance that they will defer to
    each for long.
*/

#include <uSystem.h>

#define WantIn 1
#define DontWantIn 0

void RetractIntent(int *me, int *other) {
    int i;						/* loop counter */

    for (i = 1; i <= 1000; i += 1) {			/* exercise critical section */

        /* entry protocol */

        *me = WantIn;					/* declare intent */
        while (*other == WantIn) {			/* back down & busy wait */
            *me = DontWantIn;				/* retract intent */
            while (*other == WantIn) {}			/* busy wait */
            *me = WantIn;				/* declare intent, again */
        } /* while */
    
        /* critical section */
    
        CriticalSection();

        /* exit protocol */

        *me = DontWantIn;				/* declare not interested */
    } /* for */

    uDie(NULL, 0);
} /* RetractIntent */

void uMain() {
    uTask t0, t1;
    int me, other;					/* shared between processes */

    uSetTimeSlice(10);

    me = other = DontWantIn;
    t0 = uEmit(RetractIntent, &me, &other);		/* start process */
    t1 = uEmit(RetractIntent, &other, &me);		/* start process */
 
    uAbsorb(t0, NULL, 0);				/* wait for completion of process */
    uAbsorb(t1, NULL, 0);				/* wait for completion of process */
    uPrintf("successful execution\n");
} /* uMain */
