/* includer must set QueueSize and ElemType */

struct medium {
    uSemaphore TalkerDone, ListenerDone;		/* communication semaphore */
    int front, back;
    ElemType message[QueueSize+1];
}; /* medium */

void initmedium( struct medium *med ) {
    med -> TalkerDone = U_SEMAPHORE( 0 );		/* start at 0 so listener must wait until spoken to */
    med -> ListenerDone = U_SEMAPHORE( 1 );		/* start at 1 so that talker can begin speaking to listener immediately */
    med -> front = 0;					/* buffer pointers */
    med -> back = 1;
} /* initmedium */

void talk( struct medium *med, ElemType message ) {
    uP( &med -> ListenerDone );				/* wait until listener has listened */
    med -> message[med -> back] = message;
    med -> back = ( med -> back + 1 ) % ( QueueSize + 1 );
    uV( &med -> TalkerDone );
} /* talk */

ElemType listen( struct medium *med ) {
    ElemType temp;
    
    uP( &med -> TalkerDone );				/* wait until talker has spoken */
    med -> front = ( med -> front + 1 ) % ( QueueSize + 1 );
    temp = med -> message[med -> front];
    uV( &med -> ListenerDone );				/* signal talker finished listening */
    return( temp );
} /* listen */
