#include <uSystem.h>
#include <uSGIGraphics.h>

void Coarse( void ) {
    long wid;
    Icoord xsize, ysize, x, y;

    uGrAcquire();
    foreground();
    wid = winopen( "Coarse" );
    getsize( &xsize, &ysize );
    color( RED );
    uGrRelease();

    uGrAcquire();
    winset( wid );
    for ( y = 0; y < ysize; y += 1 ) {
        for ( x = 0; x < xsize; x += 1 ) {
            pnt2i( x, y );
        } /* for */
    } /* for */
    uGrRelease();
} /* Coarse */

void Medium( void ) {
    long wid;
    Icoord xsize, ysize, x, y;

    uGrAcquire();
    foreground();
    wid = winopen( "Medium" );
    getsize( &xsize, &ysize );
    color( GREEN );
    uGrRelease();

    for ( y = 0; y < ysize; y += 1 ) {
        uGrAcquire();
        winset( wid );
        for ( x = 0; x < xsize; x += 1 ) {
            pnt2i( x, y );
        } /* for */
        uGrRelease();
    } /* for */
} /* Medium */

void Fine( void ) {
    long wid;
    Icoord xsize, ysize, x, y;

    uGrAcquire();
    foreground();
    wid = winopen( "Fine" );
    getsize( &xsize, &ysize );
    color( BLUE );
    uGrRelease();

    for ( y = 0; y < ysize; y += 1 ) {
        for ( x = 0; x < xsize; x += 1 ) {
            uGrAcquire();
            winset( wid );
            pnt2i( x, y );
            uGrRelease();
        } /* for */
    } /* for */
} /* Fine */

void uMain( int argc, char *argv[] ) {
    uTask c, m, f;

    uGrOpen( "w" );

    c = uEmit( Coarse );
    m = uEmit( Medium );
    f = uEmit( Fine );

    uAbsorb( c, NULL, 0 );
    uAbsorb( m, NULL, 0 );
    uAbsorb( f, NULL, 0 );

    uGrClose( "w" );
} /* uMain */

/* Local Variables: */
/* compile-command: "concc -compiler cc -multi SGIEx2.c -lgl_s" */
/* End: */
