#include <uSystem.h>
#include <uSGIGraphics.h>

void ShowEvents( char *name ) {
    long wid;
    uGrEvent event;
    int left, middle;

    uGrAcquire();
    foreground();
    prefsize( 200L, 60L );
    wid = winopen( name );
    doublebuffer();
    gconfig();
    uGrRelease();

    uGrQdevice( WINQUIT, NULLWIN );
    uGrQdevice( REDRAW, NULLWIN );
    uGrQdevice( LEFTMOUSE, wid );
    uGrQdevice( MIDDLEMOUSE, NULLWIN );
    left = middle = 0;
    uGrQenter( LEFTMOUSE, wid, 0 );
    uGrQenter( MIDDLEMOUSE, NULLWIN, 0 );

    for ( ;; ) {
        event = uGrQread();
        switch ( event.device ) {
          case WINQUIT:
            if ( event.value == wid ) {
                uGrUnqdevice( NULLDEV, NULLWIN );
                uGrAcquire();
                winclose( wid );
                uGrRelease();
                uDie( NULL, 0 );
            } /* if */
            break;
          case REDRAW:
            if ( event.value == wid ) {
                uGrAcquire();
                winset( wid );
                reshapeviewport();
                uGrRelease();
            } /* if */
            break;
          case LEFTMOUSE:
            left = event.value;
            break;
          case MIDDLEMOUSE:
            middle = event.value;
            break;
        } /* switch */

        uGrAcquire();
        winset( wid );
        color( BLACK );
        clear();
        color( WHITE );
        cmov2i( 9L, 29L );
        charstr( "left" );
        cmov2i( 9L, 9L );
        charstr( left ? "down" : "up" );
        cmov2i( 99L, 29L );
        charstr( "middle" );
        cmov2i( 99L, 9L );
        charstr( middle ? "down" : "up" );
        swapbuffers();
        uGrRelease();
    } /* for */
} /* ShowEvents */

void uMain( int argc, char *argv[] ) {
    uTask t1, t2;

    uGrOpen( "rw" );

    t1 = uEmit( ShowEvents, "One" );
    t2 = uEmit( ShowEvents, "Two" );

    uAbsorb( t1, NULL, 0 );
    uAbsorb( t2, NULL, 0 );

    uGrClose( "rw" );
} /* uMain */

/* Local Variables: */
/* compile-command: "concc -compiler cc -multi SGIEx3.c -lgl_s" */
/* End: */
