/*
 * Recursively calculate fibonacci numbers using a task for each function call
 */

#include <uSystem.h>

void fib( int num ) {
    uTask one, two;
    int result, result1, result2;

    uVerify();
    
    if ( num == 1 || num == 2 ) {
	result = 1;
    } else {
	one = uEmit( fib, num - 1 );
	two = uEmit( fib, num - 2 );
	uAbsorb( one, &result1, sizeof( result1 ) );
	uAbsorb( two, &result2, sizeof( result2 ) );
	result = result1 + result2;
    }
    uDie( &result, sizeof( result ) );
}

void uMain( int argc, char **argv ) {
    int num;
    int processors;
    int fibs;
    int result;
    int atoi( char *s );

    if ( argc != 3 ) {
	uError( "usage: processors fibs\n" );
    }
    
    processors = atoi( argv[1] );
    fibs = atoi( argv[2] );

    uSetTimeSlice( 0 );
    uSetStackSize( 300 );
    uSetProcessors( processors );
    
    for( num = 1; num <= fibs; num ++ ) {
	uAbsorb( uEmit( fib, num ), &result, sizeof( result ) );
	uPrintf( "fib(%d) = %d\n", num, result );
    }
    
    uDie( NULL, 0 );
}

/* Local Variables: */
/* compile-command: "parcc -O -g uFib.c" */
/* End: */
  
