/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * md-mips.i -- Machine dependent code for the uKernel.
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Thu Mar 15 10:42:34 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Dec 18 22:30:38 1990
 * Update Count     : 19
 */

static inline void uCopy( void *src, void *dst, unsigned int len ) {
    bcopy( src, dst, len );
} /* uCopy */

static inline void *uReadStackPointer( void ) {

    void *addr;
    
    asm volatile ( "move %0, $sp": "=r" (addr) );
    return( addr );
} /* uReadStackPointer */

static inline void uWriteStackPointer( void *addr ) {
    asm volatile ( "move $sp, %0" : : "r" (addr) : "sp" );
} /* uWriteStackPointer */

static inline void *uReadFramePointer( void ) {

    void *addr;
    
    asm volatile ( "move %0, $fp" : "=r" (addr) );
    return( addr );
} /* uReadFramePointer */

static inline void uWriteFramePointer( void *addr ) {
    asm volatile ( "move $fp, %0" : : "r" (addr) : "fp" );
} /* uWriteFramePointer */

static inline void *uReadReturnAddress( void ) {

    void *addr;

    asm volatile ( "move %0, $31" : "=r" (addr) );
    return( addr );
} /* uReadReturnAddress */

static inline void uWriteReturnAddress( void *addr ) {
} /* uWriteReturnAddress */

static inline void uCallUsingStack( void (*begin)() ) {

    /*
     * Load the first four arguments from the stack into
     * the registers 4, 5, 6, and 7, as the mips
     * calling convention dictates.
     */
    
    asm volatile ( "move $17, %0" : : "r" (begin) );
    asm volatile ( "lw $7, 12($sp)" );
    asm volatile ( "lw $6, 8($sp)" );
    asm volatile ( "lw $5, 4($sp)" );
    asm volatile ( "lw $4, 0($sp)" );
    asm volatile ( "jal $31, $17" );
} /* uCallUsingStack */

static inline void uMakeFrameUsingStack( uStack stack, void *buf, int len ) {
    stack->fp = stack->base;
    stack->sp = stack->fp - U_CEILING( len, sizeof( double ) );
    uCopy( buf, stack->sp, len );
} /* uMakeFrameUsingStack */
    
static inline void uPushFixedRegs( void ) {

    /*
     * Save only those registers that the GCC machine
     * configuration files specify as being saved across
     * functions calls.
     */
    
    asm volatile ( "subu $sp, 40" ); 
    asm volatile ( "sw   $16, 0($sp)" ); 
    asm volatile ( "sw   $17, 4($sp)" ); 
    asm volatile ( "sw   $18, 8($sp)" ); 
    asm volatile ( "sw   $19, 12($sp)" ); 
    asm volatile ( "sw   $20, 16($sp)" ); 
    asm volatile ( "sw   $21, 20($sp)" ); 
    asm volatile ( "sw   $22, 24($sp)" ); 
    asm volatile ( "sw   $23, 28($sp)" ); 
    asm volatile ( "sw   $30, 32($sp)" ); 
    asm volatile ( "sw   $31, 36($sp)" ); 
} /* uPushFixedRegs */

static inline void uPopFixedRegs( void ) {

    /*
     * Restore the saved registers.
     */
    
    asm volatile ( "lw   $31, 36($sp)" ); 
    asm volatile ( "lw   $30, 32($sp)" ); 
    asm volatile ( "lw   $23, 28($sp)" ); 
    asm volatile ( "lw   $22, 24($sp)" ); 
    asm volatile ( "lw   $21, 20($sp)" ); 
    asm volatile ( "lw   $20, 16($sp)" ); 
    asm volatile ( "lw   $19, 12($sp)" ); 
    asm volatile ( "lw   $18, 8($sp)" ); 
    asm volatile ( "lw   $17, 4($sp)" ); 
    asm volatile ( "lw   $16, 0($sp)" ); 
    asm volatile ( "addu $sp, 40" );
} /* uPopFixedRegs */

static inline void uPushFloatRegs( void ) {

    /*
     * Save only those registers that the GCC machine
     * configuration files specify as being saved across
     * functions calls.
     */
    
    asm volatile ( "subu $sp, 48" );
    asm volatile ( "s.d  $f20, 0($sp)" );
    asm volatile ( "s.d  $f22, 8($sp)" );
    asm volatile ( "s.d  $f24, 16($sp)" );
    asm volatile ( "s.d  $f26, 24($sp)" );
    asm volatile ( "s.d  $f28, 32($sp)" );
    asm volatile ( "s.d  $f30, 40($sp)" );
} /* uPushFloatRegs */

static inline void uPopFloatRegs( void ) {

    /*
     * Restore the saved registers.
     */
    
    asm volatile ( "l.d  $f30, 40($sp)" );
    asm volatile ( "l.d  $f28, 32($sp)" );
    asm volatile ( "l.d  $f26, 24($sp)" );
    asm volatile ( "l.d  $f24, 16($sp)" );
    asm volatile ( "l.d  $f22, 8($sp)" );
    asm volatile ( "l.d  $f20, 0($sp)" );
    asm volatile ( "addu $sp, 48" );
} /* uPopFloatRegs */

static inline void uSaveContext( register unsigned long* context ) {

    /*
     * must save frame pointer,
     *           stack pointer,
     *           instruction pointer,
     *           and registers which must be saved across procedure calls.
     */

    asm volatile ( "sw $16, %0" : "=m" (context[0]) );	/* saved regs. */
    asm volatile ( "sw $17, %0" : "=m" (context[1]) );
    asm volatile ( "sw $18, %0" : "=m" (context[2]) );
    asm volatile ( "sw $19, %0" : "=m" (context[3]) );
    asm volatile ( "sw $20, %0" : "=m" (context[4]) );
    asm volatile ( "sw $21, %0" : "=m" (context[5]) );
    asm volatile ( "sw $22, %0" : "=m" (context[6]) );
    asm volatile ( "sw $23, %0" : "=m" (context[7]) );
    asm volatile ( "sw $30, %0" : "=m" (context[8]) );	/* old sp */
    asm volatile ( "lw $2,  0($29)" ::: "v0" );		/* load the old fp */
    asm volatile ( "sw $2,  %0" : "=m" (context[9]) );	/* store the fp */
    asm volatile ( "sw $31, %0" : "=m" (context[10]) );	/* store the return address */
} /* uSaveContext */

static inline void uRestoreContext( register unsigned long* context ) {

    /*
     * must restore frame pointer,
     *           stack pointer,
     *           and registers which must be saved across procedure calls.
     * the non-zero return value is setup, 
     * followed by a jump to the return address
     */

    asm volatile ( "lw $16, %0" :: "m" (context[0]) : "s0" );
    asm volatile ( "lw $17, %0" :: "m" (context[1]) : "s1" );
    asm volatile ( "lw $18, %0" :: "m" (context[2]) : "s2" );
    asm volatile ( "lw $19, %0" :: "m" (context[3]) : "s3" );
    asm volatile ( "lw $20, %0" :: "m" (context[4]) : "s4" );
    asm volatile ( "lw $21, %0" :: "m" (context[5]) : "s5" );
    asm volatile ( "lw $22, %0" :: "m" (context[6]) : "s6" );
    asm volatile ( "lw $23, %0" :: "m" (context[7]) : "s7" );
    asm volatile ( "lw $29, %0" :: "m" (context[8]) : "sp" );  /* load old sp */
    asm volatile ( "lw $30, %0" :: "m" (context[9]) : "fp");   /* load old fp */
    asm volatile ( "lw $31, %0" :: "m" (context[10]) : "ra" ); /* load the return address */
    asm volatile ( "li $2, 1" ::: "v0" );		      /* setup result */
    asm volatile ( "j  $31" );				      /* jump back */
} /* uRestoreContext */
