/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * uProcStack.i -- Processor stack routines.
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Fri Feb  9 15:16:59 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Dec 18 22:29:56 1990
 * Update Count     : 6
 */

static inline void uAcquireProcessorStack( uProcessorStack *stack ) {

    /*
     * This function locks a processor stack.
     */

    uAcquireLock( &(stack->mutex) );			/* lock the mutex variable associated with the stack */
}

static inline void uReleaseProcessorStack( uProcessorStack *stack ) {

    /*
     * This function unlocks a processor stack.
     */

    uReleaseLock( &(stack->mutex) );			/* unlock the mutex variable associated with the stack */
}

static inline uProcessor uProcessorStackTop( uProcessorStack *stack ) {

    /*
     * This function returns the top processor on the stack.
     */

    return stack->top;
}

static inline uProcessor uProcessorStackLink( uProcessor processor ) {

    /*
     * This function returns the next processor on the stack.
     */

    return processor->link;
}

static inline int uProcessorStackEmpty( uProcessorStack *stack ) {

    /*
     * This function tests a processor stack to see if it is empty.
     */

    return stack->top == NULL;				/* is the top pointer pointing to any processor */
}

static inline int uProcessorStackLength( uProcessorStack *stack ) {

    /*
     * This function returns the number of processors on a stack.
     */

    return stack->len;
}

static inline void uPushProcessor( uProcessorStack *stack, uProcessor processor  ) {

    /*
     * This function adds a processor to the top of a processor stack.
     */

    processor->link = stack->top;
    stack->top = processor;
    stack->len += 1;
}

static inline uProcessor uPopProcessor( uProcessorStack *stack ) {

    /*
     * This function removes a task from the front of a task queue
     * and returns a reference to this task.
     */

    uProcessor processor;

    processor = stack->top;
    stack->top = processor->link;
    stack->len -= 1;

    return processor;
}
