typedef struct _Mon_condition_cell {
    _Mon_pcs *pcs;
    int data;
    struct _Mon_condition_cell *next;
} _Mon_condition_cell;

typedef struct _Mon_condition {
    int count;
    _Mon_condition_cell *head;
    _Mon_condition_cell *tail;
    _Mon_monitor *monitor;
} _Mon_condition;

static inline int uCondLength( _Mon_condition *condition ) {
    return condition -> count;
}

static inline int uCondFront( _Mon_condition *condition ) {
    return condition -> head -> data;
}

static inline void _mon_add_pcs_to_condition( _Mon_condition *condition, _Mon_condition_cell *condition_cell ) {
    condition_cell -> next = 0;
    if ( condition -> head ) {
	condition -> tail -> next = condition_cell;
    } else {
	condition -> head = condition_cell;
    }
    condition -> tail = condition_cell;
    condition -> count += 1;
}

static inline _Mon_condition_cell *_mon_remove_pcs_from_condition( _Mon_condition *condition ) {
    _Mon_condition_cell *condition_cell = condition -> head;
    condition -> head = condition -> head -> next;
    condition -> count -= 1;
    return condition_cell;
}

static inline int _mon_not_empty_condition( _Mon_condition *condition ) {
    return ( condition -> head != NULL );
}
