/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * shell.c -- 
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Wed Feb 14 13:51:49 1990
 * Last Modified By : Rick Stroobosscher
 * Last Modified On : Wed Jan 16 10:19:59 1991
 * Update Count     : 25
 */

#include <stdio.h>
#include <strings.h>
#include <uUnix.h>

/*
 *   As the shell strips escape characters from the command line before 
 *   passing it to this program, these escape characters must be reinserted
 *   prior to calling the shell with this command line again.
 */

#define SPECIALS "~`!$%&*()\\|{}[];\"'?"

int shell( char *s ) {

    /*
     * This function creates a shell to execute a command.  It calls
     * the function system() and returns the value of the system call.
     * If this function could not create a shell, it prints a message.
     */
    
    int code;
    int len = strlen( s );
    char t[len * 2];
    int i;
    int j;

    i = 0;

    for ( j = 0; j < len; j = j + 1 ) {
        if ( index(SPECIALS, s[j]) != NULL ) {

	    /*
	     * special character found, insert escape
	     */

            t[i] = '\\';
            i    = i + 1;
	} /* if */

	/*
	 * copy character to output string
	 */

        t[i] = s[j];
	i    = i + 1;
    } /* for */

    /*
     * terminate output string
     */

    t[i] = '\0';

    /*
     * Call the shell with the newly escaped string again.
     */
    
    if ( ( code = system( t ) ) == 127 ) {
	fprintf( stderr, "shell( %s ): unable to create shell.\n", t );
    } /* if */

    /*
     * The bits 8..15 from the return code from system() are the signficant
     * result bits.  Shift and return only these bits.  Much thanks to Chris
     * McDonald for this suggestion.
     */
    
    return code >> 8;
} /* shell */

/* Local Variables: */
/* compile-command: "/bin/make -k" */
/* End: */
