/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * vstrcat.c -- 
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Wed Feb 14 13:52:43 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Dec 18 22:20:12 1990
 * Update Count     : 19
 */

#ifdef mips
#include "../kernel/work/src/configure/stdarg-mips.h"
#else
#include <stdarg.h>
#endif
#include <strings.h>

void vstrcat( char *s, ... ) {

    /*
     * This function concatenates a variable length list of strings onto
     * a specified string.  The list of strings must be terminated
     * with a null reference.
     */
    
    va_list a;
    char *t;
    
    va_start( a, s );
    while ( t = va_arg( a, char * ) ) {
	strcat( s, t );
    }
    va_end( a );
}

/* Local Variables: */
/* compile-command: "/bin/make -k" */
/* End: */
