/*
 *  securelib:  a package to enhance network security.
 *
 *  Written by William LeFebvre, EECS Department, Northwestern University
 *  Internet address:  phil@eecs.nwu.edu
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/syscall.h>
#include <errno.h>

recvmsg(s, msg, flags)

int s;
struct msghdr *msg;
int flags;

{
    register int retval;

    if ((retval = syscall(SYS_recvmsg, s, msg, flags)) >= 0)
    {
	if (_ok_address(s, (struct sockaddr *)(msg->msg_name),
			msg->msg_namelen))
	{
	    return (retval);
	}
	errno = ECONNREFUSED;
	return (-1);
    }
    return (retval);
}
