/******************************************************************
 *
 *     I R I S P L O T
 *              --------------  graphic.a source
 *      Copyright 1989 Zou Maorong
 *
 ******************************************************************/

/***************************************************************
 *
 * initialize the necessary variables for global PVM 
 * and initialize graphics package
 *
 ***************************************************************/

#include <gl.h>
#include <device.h>
#include <stdio.h>
#include "graph.h"

#define ABS(x) ((x)>0 ? (x): -(x))

extern View    view;
extern Box     *box;
extern float   sizze;
extern int     set_new_angle();
extern Flag    flag;
extern oview   *ooview;

float          factor;
long int       win[4];
char           *malloc();
int            plot3d;

/*********************************
 *
 * ini_vp()
 *
 *********************************/

/*********************************/
ini_vp()
{
  sizze = MAX(  MAX( ABS( ooview->xmax - ooview->xmin), 
		    ABS( ooview->ymax - ooview->ymin)),
	      ABS( ooview->zmax - ooview->zmin));
  factor = 0.0001 * sizze;

    {
      view.proj_flag = PERSPECTIVE;
      view.left = -0.8*sizze; view.right =  0.8* sizze;
      view.bottom = -0.8*sizze; view.top = 0.8 * sizze;
      view.near = 2.8* sizze; view.far = 4.8 * sizze;
      view.fovy = 240; view.aspect= 1.30;
      view.pnear = 2.2* sizze; view.pfar = 4.8 * sizze;
      
      view.vx = 0.5 *( ooview->xmax + ooview->xmin) + 2.5 * sizze;
      view.vy = 0.5 *( ooview->ymax + ooview->ymin) + 2.5 * sizze;  
      view.vz = 0.5 *( ooview->zmax + ooview->zmin) + 1.5 * sizze;
      view.px = 0.5 *( ooview->xmax + ooview->xmin);
      view.py = 0.5 *( ooview->ymax + ooview->ymin);  
      view.pz = 0.5 *( ooview->zmax + ooview->zmin);
      view.twist = 1114;
    }
  if(plot3d == 0)
    {
      view.proj_flag = ORTHOGONAL;
      view.vx -= 2.5 * sizze; 
      view.vy -= 2.5 * sizze; 
      view.near = 0.5 * sizze;
      view.far = 2.5 * sizze;
      view.twist = 0;
    }

  if(ooview->proj_type == ORTHOGONAL)
    {
      view.proj_flag = ORTHOGONAL;
      view.left = (ooview->projections).o.left;
      view.right = (ooview->projections).o.right;
      view.top = (ooview->projections).o.top;
      view.bottom = (ooview->projections).o.bottom;
      view.near = (ooview->projections).o.near;
      view.far = (ooview->projections).o.far;
      set_look_at();
    }
  else if(ooview->proj_type == PERSPECTIVE)
    {
      view.proj_flag = PERSPECTIVE;
      view.fovy = (ooview->projections).p.fovy;
      view.aspect = (ooview->projections).p.aspect;
      view.pnear = (ooview->projections).p.pnear;
      view.pfar = (ooview->projections).p.pfar;
      set_look_at();
    }
  
  view.x_scale = 1.0;
  view.y_scale = 1.0;
  view.z_scale = 1.0;
  view.x_rot = 0; 
  view.y_rot = 0;
  view.z_rot = 0;
  view.x_trans = 0.;
  view.y_trans = 0.;
  view.z_trans = 0.;
  view.rot_old_flag = XYZ;
  view.rot_new_flag = XYZ;
  view.proj_change = 1; 
  view.view_change = 1;

  obj_box_coor();

}

/*****************************************************************/
set_look_at()
{
  view.vx = ooview->vx;   view.vy = ooview->vy;   view.vz = ooview->vz;
  view.px = ooview->px;   view.py = ooview->py;   view.pz = ooview->pz;
  view.twist = ooview->twist;
}
/**********************************************/

open_box_window()
{
  if(flag.slice)
    prefposition(850,1275,110,560);  
  else
  prefposition(850,1275,565,990);
  win[1] = winopen("IrisplotB");
  minsize(300,300);
  winconstraints();
  doublebuffer(); 
  if(!flag.cmap_flag) 
    RGBmode();
  gconfig(); 
}
open_slice_window()
{
  register int temp;
  temp = 0;
  if(flag.box_flag)
    { 
      temp = 1;
      if( win[1]) 
	close_box_window();
    }
  prefposition(850,1275,565,990);
  win[2] = winopen("IrisplotS");
  minsize(300,300);
  winconstraints();
  doublebuffer(); 
  if(!flag.cmap_flag) RGBmode();
  gconfig(); 
  if(temp)
    open_box_window();
}
close_slice_window()
{
  winclose(win[2]);
  if(flag.box_flag)
    {
      if( win[1])
	winclose(win[1]);      
      open_box_window();
    }
}
close_box_window()
{
  winclose(win[1]);
}
/************************************
 *
 *  Open windows, set configuration
 *
 ************************************/

initialize_gp()
{
  if(flag.save_image_flag == 2) /* save image for for cine */
    prefposition(24,326,744,1002); /* 479,801,383,641 */
  else
    prefposition((long)(ooview->window_position[0]),
		 (long)(ooview->window_position[1]),
		 (long)(ooview->window_position[2]),
		 (long)(ooview->window_position[3]));
  win[0] = winopen("Irisplot");
  winconstraints();
  if(flag.buffer_flag) 
    doublebuffer(); 
  if(!flag.cmap_flag)
    RGBmode();
  gconfig();

  if(flag.slice) 
    open_slice_window();
  if(flag.box_flag) 
    open_box_window();

  
  qdevice(F1KEY);   qdevice(F2KEY);   qdevice(F3KEY);  qdevice(F4KEY);
  qdevice(F5KEY);   qdevice(F6KEY);   qdevice(F7KEY);  qdevice(F8KEY);
  qdevice(F9KEY);   qdevice(F10KEY);  qdevice(SKEY);   qdevice(BKEY);
  qdevice(DKEY);    qdevice(LKEY);    qdevice(NKEY);   qdevice(ZKEY);
  qdevice(WKEY);    qdevice(RKEY);   qdevice(ESCKEY);  qdevice(XKEY);
  qdevice(LEFTMOUSE);  qdevice(RIGHTMOUSE);  qdevice(MIDDLEMOUSE);
  qdevice(REDRAW);
  attachcursor(MOUSEX,MOUSEY);
}

/***************************************************************/
ini_box()
{
  if(!box)
    box = (Box *) malloc( (unsigned) sizeof (Box));
  set_new_angle();
  box->x_scale = 1.0;  box->y_scale = 1.0; box->z_scale = 1.0; 
  box->x_rot = 300;    box->y_rot = 300;   box->z_rot = 0;
  box->x_trans = box->y_trans = box->z_trans = box->brx = box->bry = 0.0;
  box->brz = 0.0;
/*  obj_box_coor(); */
  view_box_coor();
}
/****************************************************************/
save_image_to_file()
{
  extern char  text_buffer[];
  blanktime(0);
  if(flag.save_image_flag == 1)
    (void) sprintf(text_buffer," scrsave TEMP_IMAGE.rgb %d %d %d %d ",
		   (ooview->window_position[0]),
		   (ooview->window_position[1]-1),
		   (ooview->window_position[2]),
		   (ooview->window_position[3]-1));
  else
    (void) sprintf(text_buffer," scrsave TEMP_IMAGE.rgb 25 344 745 1000");
  /* 480 799 384 639 */
  if(system(text_buffer))
    (void)fprintf(stderr,"Image saving failed\n");
  else
    {
      sleep(1);
      if(system("mv TEMP_IMAGE.rgb IMAGE.rgb"))
	(void)fprintf(stderr,"Image saving failed\n");
      else
	sleep(1);
    }
}
/****************************************************************/
