/******************************************************************
 *
 *     I R I S P L O T
 *              --------------  graphic.a source
 *      Copyright 1989 Zou Maorong
 *
 ******************************************************************/

/*********************************
 *
 *  handle input 
 *
 *********************************/

#include <gl.h>
#include <device.h>
#include <stdio.h>
#include "graph.h"

extern Menu   *menu;
extern Light  *light;
extern Lmodel *lmodel;
extern Box    *box;
extern Slice  *slice;
extern Flag   flag;
extern long int    win[4];
extern int    obj_index;
int           checkinput();
int           base_box;
unsigned      sleep();
void          exit();
/*****************************************************************/
process_input()
{
  short val; 
  int dev, menu_val;

  dev = qread(&val);
  
  switch(dev)
    {
    case REDRAW:
      redraw((long)val);
      break;

    case F1KEY:
      flag.mode_flag = 0;
      redraw_object();
      break;

    case F2KEY:
      flag.mode_flag = 1;
      redraw_object();
      break;

    case F3KEY:
      flag.mode_flag = 2;
      redraw_object();
      break;

    case F4KEY:
      flag.mode_flag = 3;
      redraw_object();
      break;

    case F5KEY:
      flag.bulb_flag = !flag.bulb_flag;
      redraw_object();
      (void)sleep(1);
      break;
	
    case F6KEY:
      flag.coor_flag = !flag.coor_flag;
      redraw_object();
      (void)sleep(1);
      break;

    case F7KEY:
      flag.big_box_flag = !flag.big_box_flag;
      redraw_object();
      (void)sleep(1);
      break;

    case F8KEY:
      base_box = !base_box;
      redraw_object();
      (void)sleep(1);
      break;

    case F9KEY:
      flag.show_message_flag = !(flag.show_message_flag);
      if(flag.show_message_flag)
	{ 
	  initialize_message();
	  display_text();
	}
      else
	{
	  free_message(); 
	  winclose(win[3]);
	  make_object();
	}
      (void)sleep(1);
      break;

    case SKEY:      
      if(flag.slice)
	{
	  flag.slice = 0; flag.slice_draw = 0;
	  flag.sp_flag = 0;
	  close_slice_window();
	}
      else
	{
	  flag.slice = 1; flag.slice_draw = 1;	  
	  flag.sp_flag = 1;
	  ini_slice();
	  open_slice_window();
	  update_slice_menu();
	}
      make_object();
      update_main_menu();
      break;
      
    case BKEY:
      if(flag.box_flag)
	{
	  flag.box_flag = 0;
	  close_box_window();
	}
      else
	{
	  flag.box_flag = 1;
	  ini_box();
	  open_box_window();
	}
      make_object();
      update_main_menu();
      break;

    case LKEY:
      flag.depthcue = 0;
      if(flag.light)
	{
	  set_no_light();
	  flag.light = 0;
	}
      else
	{
	  flag.light = 1;	  
	  if(!light)
	    {
	      ini_lm();
	      int_obj_mat();
	    }
	  flag.need_redefine_lm = 1;
	  lmodel->lmodel_change = 1;
	  update_extra_menu();
	  update_on_light_menu(0);
	  update_lmodel_menu();
	}
      make_object();
      update_main_menu();
      (void)sleep(1);
      break;

    case DKEY:
      flag.depthcue = 1;	  
      if(flag.light)
	{
	  flag.light = 0;
	  set_no_light();
	}
      update_extra_menu();
      update_main_menu();
      make_object();
      (void)sleep(1);
      break;

    case ZKEY:
      flag.zbuffer_flag = !(flag.zbuffer_flag);
      make_object();
      (void)sleep(1);
      break;

    case XKEY:
      flag.buffer_flag = !(flag.buffer_flag);
      if(flag.buffer_flag)
	{
	  doublebuffer();
	  frontbuffer(0);
	}
      else
	{
	  singlebuffer();
	  frontbuffer(1);
	}
      gconfig();
      if(flag.light)
	{
	  flag.need_redefine_lm = 1;
	  lmodel->lmodel_change = 1;
	}
      make_object();
      (void)sleep(1);
      break;

    case WKEY:
      togle_to_wire_frame();
      make_object();
      (void)sleep(1);
      break;

    case NKEY:
      togle_to_show_normal_for_surface();
      make_object();
      (void)sleep(1);
      break;

    case RKEY:
      flag.random_color++;
      flag.random_color %= 7;
      flag.random_color++;      
      make_object();
      (void)sleep(1);
      break;

    case ESCKEY:
      get_out();
      break;
      
      /* ---------------------------------------------------- */

    case RIGHTMOUSE:
      menu_val = dopup(menu->menu);
      if(menu_val <= 0) { qreset(); return;}
      switch(menu_val) 
	{
	case 1:
	  model_view_proj();
	  break;
	case 2:
	  local_model();
	  break;
	case 3:
	  freeze();
	  break;
	case 4:
	  get_out();
	  break;
	case 5:
	  reset();
	  break;
	case 6:
	  extra_stuff();
	  break;
	case 7:
	  if(flag.light) change_lm();
	  else if(flag.box_flag) change_box();
	  else if(flag.slice) change_slice();
	  break;
	case 8:
	  if(flag.light && flag.box_flag) change_box();
	  else if(flag.light && flag.slice) change_slice();
	  else change_slice();
	  break;
	case 9:
	  change_slice();
	  break;
	default:
	  break;
	}
    case LEFTMOUSE:
      if(flag.show_message_flag)
	{
	  winset(win[3]);
	  message_input_handler();
	}
      break;
    }
  qreset(); 
}
/***************************************************************/
redraw_object() 
{
  int i;
  if(!flag.slice) {
    make_object(); return; 
  } else {
    i = flag.slice_draw;
    flag.slice_draw = 1;
    make_object();
    flag.slice_draw= i;
  }
  return;
}
/***************************************************************/
freeze() 
{
  if(flag.redraw) flag.redraw = 0;
  else flag.redraw = 1;
  if(flag.redraw) 
    make_object();
  update_main_menu();
}
/**************************************************************/
redraw(win_id)
     long int win_id;
{
  int i = 0, j = 0;
  if(win_id == win[0] || win_id == win[2])
    if(!flag.redraw) 
      { flag.redraw = 1; j = 1;}
  if(win_id == win[2]) 
    {
      i = flag.slice_draw;
      flag.slice_draw = 1; 
    }
  winset(win_id);
  reshapeviewport();
  make_object();
  if( win_id == win[3])
    {
      winset(win[3]);
      define_parameters();
      draw_message_page();
    }
  if(win_id == win[2])
    flag.slice_draw = i;
  if(j) flag.redraw = 0;
}

/*************************************************************************/
get_out()
{
  greset();
  gexit();
  exit(0);
}
/***********************************************************************/ 

extra_stuff()
{
  int mval;
  extern float back_color[];

  mval = dopup(menu->extra_menu);
  
  if(mval == 1)
    if(!flag.cmap_flag)
      change_back_color(back_color);

  if(mval == 2)
    if(flag.depthcue)
      change_depthcue();
}
/**********************************************************************/

  
