
/******************************************************************
 *
 *  IRISPLOT
 *              ------------------  message.c
 *
 * Copyright 1990 Zou Maorong
 *
 ******************************************************************/

#include <stdio.h>
#include <gl.h>
#include <device.h>

#define BUFSIZE  256
#define SCROLL_BAR_WIDTH 16.0
#define LEFT_MARGIN      20.0
#define UP_ARROW          1
#define DOWN_ARROW        2
#define SCROLL_BAR        3


#define TEXT_COLOR         250,250,0
#define BACK_COLOR         50,50,50
#define SCROLL_BD_COLOR    200,200,200
#define SCROLL_HELIGHT     255,0,0
#define SCROLL_COLOR       210,210,210
#define SCROLL_BOTTOM_COLOR 140,140,140
#define SCROLL_BACK_COLOR   101,109,146
#define SCROLL_BAR_HELIGHT  240,240,240
#define RED_COLOR   255,35,55
#define GREEN_COLOR   0,182,0
#define BLUE_COLOR    0,158,255
#define YELLOW_COLOR   255,107,0
#define CYAN_COLOR   180,0,180
#define MAG_COLOR   0,184,184


#define  up_a_line()  up_lines(1)
#define  up_half_page() up_lines(row_a_page/2)
#define  up_a_page()    up_lines(row_a_page)
#define  down_a_line()  down_lines(1)
#define  down_half_page() down_lines(row_a_page/2)
#define  down_a_page()   down_lines(row_a_page)
#define  goto_the_end()  up_lines(num_rows)
#define  goto_the_top()  down_lines(num_rows)

extern int win[4];

struct text_line 
{
  char *buf;
  int index,color;
  struct text_line *prev, *next;
} *Text;

int num_rows,text_in;

static struct up_arrow {  float x1,x2,x3,y2,y3; } arrow_up;
static struct down_arrow {  float x1,x2,x3,y1,y2;} arrow_down;
static struct text_line *top_line, *bottom_line;
static float  c_x, c_y, char_dsd,char_width,char_height;
static float  scroll_x,scroll_y, scroll_x_dim, scroll_y_dim;
static float  scroll_height,scroll_current_y,scroll_factor;
static float  text_start_x,text_start_y;
static float  win_x_size,win_y_size,x_origin,y_origin;
static int    row_a_page,helight;

/**************************************************************
 * 
 *                 Page up_down routine
 *
 **************************************************************/

up_lines(nn)
     int nn;
{
  register int i = nn,j = 0;

  if(nn <= 0 || row_a_page >= num_rows ||
     bottom_line->index == num_rows) return ;
  while(i && bottom_line->next)
    {
      bottom_line = bottom_line->next;
      i--;
      j++;
    }
  while(j)
    {
      top_line = top_line->next;
      j--;
    }
  update_scroll();
  draw_message_page();
}
down_lines(nn)
     int nn;
{
  register int i = nn, j = 0;

  if(nn <= 0 || row_a_page >= num_rows ||
     top_line->index == 1) return ;
  while(i && top_line->prev)
    {
      top_line = top_line->prev;
      i--;
      j++;
    }
  while(j)
    {
      bottom_line = bottom_line->prev;
      j--;
    }
  update_scroll();
  draw_message_page();
}

scroll_move()
{
  float y_c ,temp_f;

  if(row_a_page >= num_rows) return;

  y_c = (float)getvaluator(MOUSEY) - y_origin;

  if( y_c > scroll_current_y + scroll_height)
    temp_f = scroll_height;
  else if( y_c > scroll_current_y && y_c < scroll_current_y + scroll_height)
    temp_f = y_c - scroll_current_y;
  else 
    temp_f = 0.0;

  while(getbutton(LEFTMOUSE))
    {
      y_c = (float)getvaluator(MOUSEY) - y_origin - temp_f  ;
      make_scroll_move(y_c);
    }
  helight = SCROLL_BAR;
}
make_scroll_move(amount)
     float amount;
{
  float temp_f;
  int temp_i;

  temp_f = amount; 
  scroll_current_y = temp_f;
  if(scroll_current_y > scroll_y + scroll_y_dim - scroll_height)
    scroll_current_y =  scroll_y + scroll_y_dim - scroll_height;
  if(scroll_current_y < scroll_y)
    scroll_current_y = scroll_y;
  temp_i = row_a_page + (int) ( (scroll_current_y-scroll_y)*scroll_factor) -
    bottom_line->index;
  if(temp_i > 0)
    up_lines(temp_i);
  else
    down_lines(-temp_i);

  return(0);
}

/**********************************************************/

display_text()
{
  register long long_temp;

    {
      prefposition(700,1275,5,255);
      win[3] = winopen("IrisplotM");
      doublebuffer();
      RGBmode();
      gconfig();
      winconstraints();

      long_temp = getheight();
      char_height = (float) long_temp;
      long_temp = strwidth("A");
      char_width = (float) long_temp;
      long_temp = getdescender();
      char_dsd = (float) long_temp;
  
      helight = 0;

      arrow_up.x1 = 3.0;
      arrow_up.x2 = 10.0;
      arrow_up.x3 = 17.0;

      arrow_down.x1 = 3.0;
      arrow_down.x2 = 10.0;  
      arrow_down.x3 = 17.0;    
      arrow_down.y1 = 2.0;
      arrow_down.y2 = 16.0;
      scroll_x = 2.0;
      scroll_y = LEFT_MARGIN + 2.0;
      scroll_x_dim = SCROLL_BAR_WIDTH;
      text_start_x = 2.0 * char_width + LEFT_MARGIN;
      scroll_current_y = scroll_y;

      define_parameters();
      draw_message_page();
    }
}

define_parameters()
{
  struct text_line *temp = Text;  
  long x_size,y_size;
  
  getsize(&x_size,&y_size);
  win_x_size = (float)x_size;
  win_y_size = (float)y_size;
  row_a_page = (int) (win_y_size/(char_height+char_dsd)) - 1; 

  top_line = temp;
  while(temp->index < row_a_page && temp->next)
    temp = temp->next;
  bottom_line = temp;


  getorigin(&x_size,&y_size);
  x_origin = (float)x_size;
  y_origin = (float)y_size;
  scroll_y_dim = win_y_size - 2.0*scroll_y;
  text_start_y = win_y_size - 1.5*(char_height+char_dsd);
  arrow_up.y2 = win_y_size - LEFT_MARGIN + 4.0;
  arrow_up.y3 = win_y_size - 2.0;  

  define_other_paras();
}

extern struct text_line *current_last_line;

define_other_paras()
{

  if( row_a_page < num_rows)
    scroll_height = scroll_y_dim * (float)row_a_page/(float)num_rows;
  else
    scroll_height = scroll_y_dim;

  scroll_factor = (float)(num_rows-row_a_page)/(scroll_y_dim - scroll_height);

  bottom_line = current_last_line;

  while(bottom_line->index - top_line->index > row_a_page)
    top_line = top_line->next;

}
  
/****************************************************************/

update_scroll()
{
  register float temp = (float) (bottom_line->index-row_a_page);

  scroll_current_y = scroll_y + temp/(float)(num_rows-row_a_page) 
    *(scroll_y_dim - scroll_height);
}

reset_scroll()
{
  num_rows = 0;
  row_a_page = 0;
}

/******************************************************************/

#define Red 1
#define Grn 2
#define Blu 3
#define Cya 4
#define Yel 5
#define Mag 6


draw_text()
{
  float temp_ff = char_height + char_dsd;
  struct text_line *temp_line = top_line;
  int done;

  c_x = text_start_x;
  c_y = text_start_y;
  done = 0;

  while( !done)
    {
      cmov2(c_x,c_y);

      switch(temp_line->color)
	{
	case Red:
	  RGBcolor(RED_COLOR);      
	  break;
	case Grn:
	  RGBcolor(GREEN_COLOR);      
	  break;
	case Blu:
	  RGBcolor(BLUE_COLOR);      
	  break;
	case Yel:
	  RGBcolor(YELLOW_COLOR);      
	  break;
	case Cya:
	  RGBcolor(CYAN_COLOR);      
	  break;
	case Mag:
	  RGBcolor(MAG_COLOR);      
	  break;
	default:
	  RGBcolor(TEXT_COLOR);  
	  break;
	}
      charstr(temp_line->buf);
      c_y -= temp_ff;
      if(temp_line == bottom_line)
	done = 1;
      if(!done)
	temp_line = temp_line->next;
    }
}
draw_up_arrow()
{
  if(helight == UP_ARROW)
    RGBcolor(SCROLL_BAR_HELIGHT);
  else
    RGBcolor(SCROLL_COLOR);
  pmv2(arrow_up.x1,arrow_up.y2);
  pdr2(arrow_up.x2,arrow_up.y3);
  pdr2(arrow_up.x3,arrow_up.y2);
  pclos();
  linewidth(2);
  RGBcolor(SCROLL_BOTTOM_COLOR);
  move2(arrow_up.x3,arrow_up.y2);
  draw2(arrow_up.x1,arrow_up.y2);  
  RGBcolor(SCROLL_BD_COLOR);

  move2(arrow_up.x1,arrow_up.y2);
  draw2(arrow_up.x2,arrow_up.y3);
  draw2(arrow_up.x3,arrow_up.y2);
  linewidth(1);
}
draw_down_arrow()
{
  if(helight == DOWN_ARROW)
    RGBcolor(SCROLL_BAR_HELIGHT);
  else
    RGBcolor(SCROLL_COLOR);
  pmv2(arrow_down.x1,arrow_down.y2);
  pdr2(arrow_down.x3,arrow_down.y2);
  pdr2(arrow_down.x2,arrow_down.y1);
  pclos();

  linewidth(2);
  RGBcolor(SCROLL_BOTTOM_COLOR);
  move2(arrow_down.x1,arrow_down.y2);
  draw2(arrow_down.x2,arrow_down.y1);
  draw2(arrow_down.x3,arrow_down.y2);
  RGBcolor(SCROLL_BD_COLOR);
  move2(arrow_down.x1,arrow_down.y2);
  draw2(arrow_down.x3,arrow_down.y2);
  linewidth(1);
}
draw_scroll_back()
{
  RGBcolor(SCROLL_BACK_COLOR);
  pmv2(0.0,0.0);
  pdr2(0.0,win_y_size);
  pdr2(LEFT_MARGIN,win_y_size);
  pdr2(LEFT_MARGIN,0.0);
  pclos();
}
draw_scroll_bar()
{
  RGBcolor(TEXT_COLOR);
  move2(LEFT_MARGIN+1,0.0);
  draw2(LEFT_MARGIN+1,win_y_size);
  move2(0.0,LEFT_MARGIN);
  draw2(LEFT_MARGIN+1,LEFT_MARGIN);
  move2(0.0,win_y_size-LEFT_MARGIN);
  draw2(LEFT_MARGIN+1,win_y_size-LEFT_MARGIN);

  draw_scroll_bar_only();
}

draw_scroll_bar_only()
{
  if(helight == SCROLL_BAR)
    RGBcolor(SCROLL_BAR_HELIGHT);
  else
    RGBcolor(SCROLL_COLOR);
  pmv2(scroll_x,scroll_current_y);
  pdr2(scroll_x,scroll_current_y + scroll_height);
  pdr2(scroll_x +scroll_x_dim,scroll_current_y + scroll_height);
  pdr2(scroll_x +scroll_x_dim,scroll_current_y );
  pclos();
  linewidth(2);
  RGBcolor(SCROLL_BOTTOM_COLOR);
  move2(scroll_x +scroll_x_dim,scroll_current_y + scroll_height);
  draw2(scroll_x +scroll_x_dim,scroll_current_y );  
  draw2(scroll_x,scroll_current_y);
  RGBcolor(SCROLL_BD_COLOR);
  move2(scroll_x,scroll_current_y);
  draw2(scroll_x,scroll_current_y + scroll_height);
  draw2(scroll_x +scroll_x_dim,scroll_current_y + scroll_height);
  linewidth(1);
}
/***********************************************************************/

draw_message_page()
{
  ortho2(0.0,win_x_size,0.0,win_y_size);
  RGBcolor( BACK_COLOR);
  clear();
  draw_scroll_back();

  draw_up_arrow();
  draw_down_arrow();
  draw_scroll_bar();
  draw_text();
  swapbuffers();
}
/*********************************************************/

update_messages()
{
  winset(win[3]); 
  num_rows += text_in;
  define_other_paras();
  update_scroll();
  draw_message_page();  
  text_in = 0;
}
/*********************************************************/

message_input_handler()
{
  float mouse_x,mouse_y;

  mouse_x = (float) getvaluator(MOUSEX) - x_origin;
  mouse_y = (float) getvaluator(MOUSEY) - y_origin;
  if(mouse_x > 0.0 && mouse_x < LEFT_MARGIN &&
     mouse_y > 0.0 && mouse_y < LEFT_MARGIN)
    {
      while(getbutton(LEFTMOUSE))
	{
	  helight = DOWN_ARROW;
	  down_a_line();
	  helight = 0;
	}
    }
  else if( mouse_x >0.0 && mouse_x < LEFT_MARGIN &&
	  mouse_y > win_y_size - LEFT_MARGIN &&
	  mouse_y < win_y_size)
    {
      while(getbutton(LEFTMOUSE))
	{
	  helight = UP_ARROW;
	  up_a_line();
	  helight = 0;
	}
    }
  else  if(mouse_x >= scroll_x && mouse_x <= scroll_x + scroll_x_dim &&
	   mouse_y >= scroll_y && mouse_y <= scroll_y + scroll_y_dim)
    {
      helight = SCROLL_BAR;
      scroll_move();
      helight = 0;
      draw_message_page();
    }
}
/****************************************************************/
check_mouse()
{
  float mouse_x,mouse_y;

  mouse_x = (float) getvaluator(MOUSEX) - x_origin;
  mouse_y = (float) getvaluator(MOUSEY) - y_origin;
  if(mouse_x > 0.0 && mouse_x < LEFT_MARGIN &&
     mouse_y > 0.0 && mouse_y < LEFT_MARGIN)
    {
      frontbuffer(1);
      helight = DOWN_ARROW;
      draw_up_arrow();     
      draw_down_arrow();
      draw_scroll_bar_only();
      frontbuffer(0);
    }
  else if( mouse_x >0.0 && mouse_x < LEFT_MARGIN &&
	  mouse_y > win_y_size - LEFT_MARGIN &&
	  mouse_y < win_y_size)
    {
      frontbuffer(1);
      helight = UP_ARROW;
      draw_up_arrow();     
      draw_down_arrow();
      draw_scroll_bar_only();
      frontbuffer(0);
    }
  else  if(mouse_x >= scroll_x && mouse_x <= scroll_x + scroll_x_dim &&
	   mouse_y >= scroll_current_y 
	   && mouse_y <= scroll_current_y + scroll_height)
    {
      frontbuffer(1);
      helight = SCROLL_BAR;
      draw_up_arrow();     
      draw_down_arrow();
      draw_scroll_bar_only();
      frontbuffer(0);
    }
  else if(helight != 0)
    {
      helight = 0;
      frontbuffer(1);
      draw_up_arrow();     
      draw_down_arrow();
      draw_scroll_bar_only();
      frontbuffer(0);
    }
}
/****************************************************************/


