/******************************************************************
 *
 *     I R I S P L O T
 *              --------------  graphic.a source
 *      Copyright 1989 Zou Maorong
 *
 ******************************************************************/


/********************************************************************/

#include <gl.h>
#include <device.h>
#include <stdio.h>
#include <math.h>
#include "graph.h"

extern Flag  flag;
extern View  view;
extern Menu  *menu;
extern float factor;
extern float sizze;
extern void  (*drawf)();
extern Slice *slice;
extern oview *ooview;
char   *malloc();

static float splane[] = {
  EMISSION,0.2,0.2,0.2,
  AMBIENT,0.0,0.0,0.0,
  SPECULAR,0.8,0.8,0.8,
  DIFFUSE,0.5,0.5,0.5,
  SHININESS,43.0,
  ALPHA, 0.5,
  LMNULL};
static float back_color_slice[3];

/********************************************/
ini_slice()
{
  float uv;
  if(!slice) 
    {
      slice = (Slice *)malloc((unsigned)sizeof(Slice));
      uv = 1.2 * sizze;
      slice->vx = slice->vy = 0.0;   slice->vz = 1.0;
      slice->left = - uv;  slice->right =  uv;
      slice->bottom = - uv;   slice->top = uv;
      slice->near = - 0.0025* sizze; slice->far = - slice->near;
      slice->p_factor = sizze;
      slice->dist = 0.0;
      slice->scale = 1.0;
      lmdef(DEFMATERIAL,SLICEPLANEMAT,21,splane);
    }
}
/**************************************************/

draw_slice()
{
  float temp;
  temp = slice->dist * slice->scale;

  ortho(slice->left,slice->right,slice->bottom,
	slice->top,slice->near,slice->far);
  lookat(slice->vx * temp,
	 slice->vy * temp,
	 slice->vz * temp,
	 - slice->vx * slice->scale,
	 - slice->vy * slice->scale,
	 - slice->vz * slice->scale,0); 
  scale(slice->scale,slice->scale,slice->scale);

  if(flag.cmap_flag) color(0);
  else c3f( back_color_slice);
  clear();

  if(flag.mode_flag <= 1)
    /* ------------------------------------------------- */
    {
      if(!flag.mode_flag)
	translate(view.x_trans,view.y_trans,view.z_trans);
      scale(view.x_scale,view.y_scale,view.z_scale);
      set_rotation(view.rot_old_flag,view.x_rot,view.y_rot,view.z_rot);
      if(flag.mode_flag)
	translate(view.x_trans,view.y_trans,view.z_trans);
    }
  /* ------------------------------------------------- */
  if(flag.cmap_flag) color(3583);
  else cpack(0x00ffff00);
  drawf();
  swapbuffers();
}

/*********************************************************************/

change_slice()
{
  int menu_val;

  menu_val = dopup(menu->slice_menu);
  if(menu_val < 0) {qreset(); return;}
  flag.slice_draw = 1;

  if( menu_val != 6)
    {
      flag.sp_flag = 1;
      update_slice_menu();
    }

  if(menu_val == 1) change_s_direction();
  else if(menu_val == 2) scale_s_object();
  else if(menu_val == 3) change_s_distance();
  else if(menu_val == 4) change_proj_box();
  else if(menu_val == 5) scale_plane();
  else if(menu_val == 6) 
    {
      flag.slice_draw = 0;
      if(flag.sp_flag) flag.sp_flag = 0;
      else flag.sp_flag = 1;
      make_object();
      update_slice_menu();
    }
  else if(menu_val == 7)   
    {
      flag.slice_draw = 1;
      change_back_color(back_color_slice);
    }
  flag.slice_draw = 0;
  qreset();
}
/**********************************************************************/

change_proj_box()
{
  int menu_val,dev,x0,x1;
  short val; float dx;

 tryagain:
  menu_val = dopup(view.ortho_menu);
  if(menu_val <= 0) return; 
  x0 = getvaluator(MOUSEX);  
 try1:
  while(!qtest())
    {
      x1 = getvaluator(MOUSEX);
      dx = factor* (float) (x1-x0);

      if(menu_val == 1) slice->left -= dx;
      else if(menu_val == 2) slice->right -= dx;
      else if(menu_val == 3) slice->bottom -= dx;
      else if(menu_val == 4) slice->top += dx;
      else if(menu_val == 5) slice->near -=0.001* dx;
      else if(menu_val == 6) slice->far += 0.001* dx;
      make_object();
    }
  dev = qread(&val);
  if(dev == INPUTCHANGE) goto try1;
  if(dev == RIGHTMOUSE ) goto tryagain;
}

/****************************************************************/

change_s_distance()
{
  int dev,x0,x1;
  short val; float dx;

 tryagain:

  x0 = getvaluator(MOUSEX);
 try1:
  while(!qtest())
    {
      x1 = getvaluator(MOUSEX);      
      dx = 0.5* factor * (float) (x1 - x0);
      slice->dist += dx;
      make_object();
      }
  dev = qread(&val); 
  if(dev == INPUTCHANGE) 
    {
      if(flag.show_message_flag) 
	show_slice(); 
      goto try1;
    }
  if(dev == RIGHTMOUSE ) 
    {
      if(flag.show_message_flag) 
	show_slice(); 
      goto tryagain;
    }
}
/******************************************************************/

change_s_direction()
{
  int menu_val,dev, x0,x1;
  short val; float dx,theta,phi;

  theta = asin(slice->vz);
  if(slice->vx == 0. && slice->vy == 0.)
    phi = 0.;
  else
    phi = acos( (slice->vx )/ sqrt( (slice->vx *slice->vx ) + 
				     slice->vy * slice->vy));
  if((slice->vy) < 0.) phi = 6.28318 - phi;

 tryagain:
  menu_val = dopup(menu->dir_menu);
  if(menu_val <= 0) return; 

  x0 = getvaluator(MOUSEX);
 try1:
  while(!qtest())
    {
      x1 = getvaluator(MOUSEX);      
      dx = 0.0005* (float) (x1 - x0);

      if(menu_val == 1) theta += dx;
      else if(menu_val == 2) phi += dx;

      slice->vx  = cos(theta) * cos(phi);
      slice->vy  = cos(theta)* sin(phi);
      slice->vz  = sin(theta);

      make_object();
    }
  dev = qread(&val);
  if(dev == INPUTCHANGE) 
    {
      if(flag.show_message_flag) 
	show_slice(); 
      goto try1;
    }
  if(dev == RIGHTMOUSE)
    {
      if(flag.show_message_flag) 
	show_slice(); 
      goto tryagain;
    }
}
/*************************************************************************/

scale_s_object()
{
  int menu_val,dev,x0,x1;
  short val; float dx;

 tryagain:
  menu_val = dopup(menu->scale_only);
  if(menu_val <= 0) return; 
  x0 = getvaluator(MOUSEX);
 try1:
  while(!qtest())
    {
      x1 = getvaluator(MOUSEX);      
      dx = 0.0005 * (float) (x1 - x0);
      if(menu_val == 1)
	slice->scale += dx;
      
      make_object();
      }
  dev = qread(&val);
  if(dev == INPUTCHANGE) 
    {
      if(flag.show_message_flag) 
      show_slice(); 
      goto try1;
    }
  if(dev == RIGHTMOUSE )
    {
      if(flag.show_message_flag) 
	show_slice(); 
      goto tryagain;
    }
}
/**********************************************************************/
scale_plane()
{
  int dev,x0,x1;
  float dx;
  short val;

  flag.slice_draw = 0;

 tryagain:


  x0 = getvaluator(MOUSEX);
 try1:
  while(!qtest())
    {
      x1 = getvaluator(MOUSEX);
      dx = factor * (float) (x1 - x0);
      slice->p_factor += (dx);
      make_object();
    }
  dev = qread(&val);
  if(dev == INPUTCHANGE) goto try1;
  if(dev == RIGHTMOUSE ) goto tryagain;
}
/***************************************************************************/

#define  PXXX  slice->vx 
#define  PYYY  slice->vy
#define  PZZZ  slice->vz

draw_slice_plane()
{
  float xsx[4][3],nx[3],v1,v2,v3,u1,u2,u3,dx,dy,dz;
  float norm;

  nx[0] = - PXXX;  nx[1] = - PYYY;  nx[2] = - PZZZ;

  /* calculate the displacement from the object origin */
  dx = slice->dist * slice->vx;
  dy = slice->dist * slice->vy;
  dz = slice->dist * slice->vz;

  /* define the coordinate of  the slice plane */

  if( fabs(PXXX) >= 0.00510)
    {
      u1 = PZZZ; u2 = 0. ; u3 = - PXXX;
      norm = sqrt(u1* u1 + u3* u3);
      u1 /= norm;       u3 /= norm;
      v1 = - PYYY* PXXX ;  v2 = PZZZ* PZZZ + PXXX* PXXX ; v3 = - PYYY* PZZZ;
      norm = sqrt( v1* v1 +v2* v2+ v3*v3);
      v1 /= norm; v2 /= norm; v3 /= norm;
    } 
  else 
    {
      u1 = 0. ; u2 = PZZZ; u3 = -PYYY;
      norm = sqrt(u2* u2 +u3* u3);
      u2 /= norm;      u3 /= norm;
      v1 = - PYYY* PYYY - PZZZ * PZZZ; v2 = PXXX* PYYY; v3 = PXXX *PZZZ ;
      norm = sqrt( v1* v1 +v2* v2+ v3*v3);
      v1 /= norm; v2 /= norm; v3 /= norm;
    } 

  u1 *= slice->p_factor;
  u2 *= slice->p_factor;
  u3 *= slice->p_factor;
  v1 *= slice->p_factor;  
  v2 *= slice->p_factor;  
  v3 *= slice->p_factor;  

  /* define the vertices of the slice plane */
  
  xsx[0][0] = - u1 + dx;
  xsx[0][1] = - u2 + dy;
  xsx[0][2] = - u3 + dz;
  xsx[1][0] =   v1 + dx; 
  xsx[1][1] =   v2 + dy; 
  xsx[1][2] =   v3 + dz;
  xsx[2][0] =   u1 + dx;
  xsx[2][1] =   u2 + dy; 
  xsx[2][2] =   u3 + dz;
  xsx[3][0] = - v1 + dx; 
  xsx[3][1] = - v2 + dy;
  xsx[3][2] = - v3 + dz;

  if(flag.light)
    {
      backface(1);
      n3f(nx);
    }
  bgnpolygon();
  v3f(xsx[0]);  v3f(xsx[1]);  v3f(xsx[2]);  v3f(xsx[3]);
  endpolygon();
  if(flag.light)
    {
      nx[0] *= -1.0;       nx[1] *= -1.0;      nx[2] *= -1.0;
      n3f(nx);
      bgnpolygon();
      v3f(xsx[3]);  v3f(xsx[2]);  v3f(xsx[1]);  v3f(xsx[0]);
      endpolygon();
      backface(0);
    }
}

/**************************************************************************/
