
/* 
 * This is the utimer package for sun4c, which provides timestamps with 
 * granularity of < 100 usecs (mocroseconds, yep!)
 *
 * (c) Silvano Maffeis 1991, ifi,  University of Zurich, 
 *                 maffeis@ifi.unizh.ch
 *
 */

#define SYS_utimer 190
enum param {ENQUIRE_LO, ENQUIRE_HI, START, INIT, NOSWAP, SWAPOK, NICENESS};

/* 
 * usage: syscall(param, arg1, ...)
 *
 * param's:
 *
 * INIT, arg1		:Initializes the utimer. arg1 holds the counter-limit.
 *			 Each time counter-limit is reached, a level14 interrupt
 *			 occurs and hi_counter is incremented by 1. (lo_counter
 *			 is incremented once each usec.)
 *			 Usually arg1 is set =0 which means a maximum limit:
 *			 then interrupts occur roughly each 2 sec (exactly each 
 *			 2^21 usecs.)
 *			 Returns 1 on success, -1 on failure.
 *
 * START		:hi_- and lo_counter are set to 0 and started.
 *			 Returns 1 per default.
 *
 * ENQUIRE_LO		:Returns the value of low counter (lo_counter).
 *
 * ENQUIRE_HI		:Returns the value of high counter (hi_counter).
 *
 * NOSWAP		:Marks the calling process as un-swappable.
 *			 Returns 1 per default.
 *
 * SWAPOK		:Marks the calling process as swappable. (Can be used only
 *			 after NOSWAP).
 *			 Returns 1 on success, -1 on failure.
 *
 * NICENESS, arg1	:Sets niceness of process to arg1: 0= highest, 
 *			 20= normal, 39= lowest priority.
 *			 Returns the old niceness.
 */

