/*
 * remote, gremote - do an 'rlogin' through a machine.
 *
 * 	If invoked as gremote, it will invoke 'rlogin -8' to support
 *	graphics terminals.
 *
 *  	Right now, it is hard-wired to disallow dialups on boulder only
 * 	if this becomes a popular feature, it should be generalized.
 *
 * 
 */

#include <stdio.h>
#include <sys/file.h>
#include <sys/syslog.h>

#define HOSTNAME_SIZE 32
#define NAME_SIZE 8
#define LOGSTAT LOG_LOCAL0

FILE *fd,*fopen();
char *index(),*rindex(),*getenv();

main (ac,av)
	int ac;
	char **av;
{
	char host[HOSTNAME_SIZE];
	char thishost[HOSTNAME_SIZE];
	char username[NAME_SIZE];
	char *cmdname;
	char *ttytype;
	char *ttyn, *ttyname();
	int i;
	short int  eightbit = 0;	/* flag true if rlogin -8 wanted */


	cmdname = *av; 
	if (*cmdname == '-')
		cmdname++;

	openlog(cmdname,0,LOGSTAT);

	/* Look at the environment and get the type of the tty */
	ttytype = getenv("TERM");

	/* if this is a machine from which you do not want dialups
		to get access to remote login capabilities -- then nuke 'em */

	gethostname(thishost,sizeof(thishost));

	if ( (strncmp("\fIYour_machine_name\fC",thishost,sizeof(thishost)) == 0) &&
	     (strncmp("dialup",ttytype, sizeof(ttytype))  == 0)     )
	{
		printf ("%s:Sorry, %ss not permitted on dialups on %s.\n",
		        cmdname,cmdname,thishost);

		syslog(LOG_INFO,"on %s failed",thishost);
		sleep(1);
		exit(0);
	}

	if (*cmdname == 'g')
		eightbit++;

	/* prompt for hostname */
	printf ("hostname: ");
	alarm(120);
	gets(host); 

	/* prompt the remote login */
	printf ("%s login: ",host);
	scanf ("%s",username); 
	alarm(0);

	/* if they invoked us as 'gremote' give them the 8 bit interface */
	if (eightbit) {
		syslog(LOG_INFO,"gremote host: %s, user: %s",host,username);
		execl 
	       ("/usr/ucb/rlogin",host, "-8" ,"-l",username,"-e\0177",0);
	}
	else {
		syslog(LOG_INFO,"remote host: %s, user: %s",host,username);
		execl 
	       ("/usr/ucb/rlogin",host,"-l",username,"-e\0177",0);
	}
}/* main */
