/*
** clrusr.c
*/

#include <stdio.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <ctype.h>

char    *getpass();
char    *crypt();

#define TIMEDIR    "/usr/local/adm/sudocheck/"  /* Dir for time stamps */
#define INFO_FILE  "/usr/local/adm/sudocheck/sudo.doc" 

#define INVALID    -1           /* Returned by system routines */
#define SUDO_OK    1            /* Flag: good validation */
#define TIME       5            /* Validation time, in mins */

/*
**  The not_timed_out() routine checks to be
**  sure a user is not prevalidated.  If he 
**  (or she) is already valid, they need not
**  retype the password.
*/

not_timed_out(name,password)

char    *name;        /* Username of person */
char    *password;    /* And their encrypted passwd */

{
    char      fname[200];
    struct    stat stab;
    
    sprintf (fname, "%s%s",TIMEDIR,name);
    
    if (access(fname, F_OK))
    {
        /* Validation file doesn't exist, create it */
        get_password(password);
        create_file(fname);
        return(SUDO_OK);
    }
    
    if(stat(fname, &stab))
    {
        fprintf (stderr,"Gag, can't stat validation file.\en");
        exit(1);
    }
    
    if ((time(NULL) - stab.st_mtime) > (TIME * 60))
    {
        get_password(password);
    }
    create_file(fname);
    return (SUDO_OK);
}

/*
**  get_password() solicits a password and 
**  compares it against the users own 
**  password.
*/

get_password(password)

char    *password;          /* User's encrypted password */

{
    char    *paswd;
    char    *encrypted;
    
    paswd = getpass("Password:");
    encrypted = crypt(paswd,password);

    if (strcmp(password,encrypted))
    {
        fprintf (stderr,"Password incorrect\n");
        exit(3);
    }
    
    fflush(stderr);
    fflush(stdout);
}

/*
**  create_file() sets the modtime of the
**  validation file.
*/

create_file(file)

char    *file;        /* Filename to be created */

{
    int   descrip;
    long  timep[2];

    descrip = open(file, O_TRUNC | O_CREAT | O_WRONLY, 0700);
    
    if(descrip == INVALID)
    {
        printf("Gag, couldn't open validation file.\en");
        exit(4);
    }
    close(descrip);

    timep[0] = timep[1] = time(0); 
    utime(file, timep);
}


