/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.term;

import gnu.prolog.term.NumericTerm;

public class IntegerTerm
extends NumericTerm {
    private static final long serialVersionUID = 4778268363190379033L;
    private static final int CACHESIZE = 65536;
    private static final int HALFCACHESIZE = 32768;
    protected static IntegerTerm[] cache = new IntegerTerm[65536];
    public static final IntegerTerm int_m2 = IntegerTerm.get(-2);
    public static final IntegerTerm int_m1 = IntegerTerm.get(-1);
    public static final IntegerTerm int_0 = IntegerTerm.get(0);
    public static final IntegerTerm int_1 = IntegerTerm.get(1);
    public static final IntegerTerm int_2 = IntegerTerm.get(2);
    public static final IntegerTerm int_3 = IntegerTerm.get(3);
    public static final IntegerTerm int_4 = IntegerTerm.get(4);
    public final int value;

    public static IntegerTerm get(int val) {
        IntegerTerm rc;
        int idx = val + 32768;
        if (idx >= 0 && idx < 65536) {
            rc = cache[idx];
            if (rc == null) {
                IntegerTerm.cache[idx] = rc = new IntegerTerm(val);
            }
        } else {
            rc = new IntegerTerm(val);
        }
        return rc;
    }

    protected static int parseInt(String str) {
        int sign = 1;
        try {
            int val;
            block28: {
                block29: {
                    if (str.charAt(0) == '-') {
                        sign = -1;
                        str = str.substring(1);
                    }
                    if (str.charAt(0) != '0' || str.length() <= 1) break block29;
                    switch (str.charAt(1)) {
                        case 'B': 
                        case 'b': {
                            val = Integer.parseInt(str.substring(2), 2);
                            break block28;
                        }
                        case 'O': 
                        case 'o': {
                            val = Integer.parseInt(str.substring(2), 8);
                            break block28;
                        }
                        case 'X': 
                        case 'x': {
                            val = Integer.parseInt(str.substring(2), 16);
                            break block28;
                        }
                        case '\'': {
                            str = str.substring(2);
                            block25: while (true) {
                                switch (str.charAt(0)) {
                                    case '\\': {
                                        switch (str.charAt(1)) {
                                            case '\\': {
                                                val = 92;
                                                break;
                                            }
                                            case 'n': {
                                                val = 10;
                                                break;
                                            }
                                            case '\'': {
                                                val = 39;
                                                break;
                                            }
                                            case '\"': {
                                                val = 34;
                                                break;
                                            }
                                            case 'b': {
                                                val = 8;
                                                break;
                                            }
                                            case 'a': {
                                                val = 7;
                                                break;
                                            }
                                            case 'r': {
                                                val = 13;
                                                break;
                                            }
                                            case 't': {
                                                val = 9;
                                                break;
                                            }
                                            case 'v': {
                                                val = 11;
                                                break;
                                            }
                                            case '\r': {
                                                str = str.substring(str.charAt(2) == '\n' ? 3 : 2);
                                                continue block25;
                                            }
                                            case '\n': {
                                                str = str.substring(str.charAt(2) == '\r' ? 3 : 2);
                                                continue block25;
                                            }
                                            case 'x': {
                                                val = 0;
                                                int i = 2;
                                                while (str.charAt(i) != '\\') {
                                                    val = val * 16 + Character.digit(str.charAt(i), 16);
                                                    ++i;
                                                }
                                                break block28;
                                            }
                                            default: {
                                                val = str.charAt(1);
                                                break;
                                            }
                                        }
                                        break block28;
                                    }
                                    default: {
                                        val = str.charAt(0);
                                        break block25;
                                    }
                                }
                                break;
                            }
                            break block28;
                        }
                        default: {
                            throw new IllegalArgumentException("argument should be integer number");
                        }
                    }
                }
                val = Integer.parseInt(str);
            }
            return val * sign;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("argument should be integer number");
        }
    }

    public static IntegerTerm get(String str) {
        return IntegerTerm.get(IntegerTerm.parseInt(str));
    }

    public IntegerTerm(String str) {
        this(IntegerTerm.parseInt(str));
    }

    public IntegerTerm(int val) {
        this.value = val;
    }

    public int getTermType() {
        return 4;
    }
}

